/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.PatchFile;
import com.ibm.hwmca.base.updates.UpdatesErrorIds;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.shutdown.ShutdownManager;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public final class FilePermissionsChanger
implements UpdatesErrorIds {
    private static final String TRACE_MASKT = "XMCFPRMT";
    private static final String TRACE_MASKF = "XMCFPRMF";
    private static final String TRACE_MASKD = "XMCFPRMD";
    private static final String TRACE_CLASS = "FilePermissionsChanger";
    private static final String TRACE_IN = "-> ";
    private static final String TRACE_OUT = "<- ";
    private static final String TRACE_INOUT = "<> ";
    private static final String TRACE_OTHER = "   ";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(2, "McfPerms");
    private static FilePermissionsChanger theFilePermissionsChanger = null;
    private static final String PERMISSIONS_DATA_FILE = "iqzmPermissions.dat";
    private static final String SHUTDOWN_SCRIPT_NAME = "iqzmShutdownProcessing.pl";
    private static final String DEFAULT_SAFE_OWNER = "hmcmanager";
    private static final String DEFAULT_SAFE_GROUP = "nobody";
    private static final String DEFAULT_SAFE_FLAGS = "755";
    private static final Object mylock = new Object();
    public static final int WHEN_NOW = 711;
    public static final int WHEN_REBOOT = 712;
    public static final int MODE_ADD = 821;
    public static final int MODE_EXIST = 822;
    private Hashtable filePerms = new Hashtable();

    private static synchronized FilePermissionsChanger getFilePermissionsChanger() {
        String TRACE_METHOD = ".getFilePermissionsChanger()";
        Trace.trace(TRACE_MASKT, "-> FilePermissionsChanger" + TRACE_METHOD);
        if (theFilePermissionsChanger == null) {
            theFilePermissionsChanger = new FilePermissionsChanger();
        }
        Trace.trace(TRACE_MASKT, "<- FilePermissionsChanger" + TRACE_METHOD);
        return theFilePermissionsChanger;
    }

    private FilePermissionsChanger() {
        String TRACE_METHOD = ".ctor()";
        Trace.trace(TRACE_MASKT, "<> FilePermissionsChanger" + TRACE_METHOD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean changeFilePermissions(String file, String owner, String group, String flags, int when, int mode) throws IllegalArgumentException {
        String TRACE_METHOD = ".changeFilePermissions()";
        Trace.trace(TRACE_MASKT, "-> FilePermissionsChanger" + TRACE_METHOD);
        FilePermissionsChanger me = FilePermissionsChanger.getFilePermissionsChanger();
        boolean isSafe = PatchFile.isPathSafe(file);
        if (711 == when) {
            boolean doItNow = true;
        } else if (712 == when) {
            boolean doItNow = false;
        } else {
            throw new IllegalArgumentException("Invalid \"when\" argument");
        }
        if (821 == mode) {
            boolean modeNew = true;
        } else if (822 == mode) {
            boolean modeNew = false;
        } else {
            throw new IllegalArgumentException("Invalid \"when\" argument");
        }
        if (null == owner) {
            owner = "";
        }
        if (null == group) {
            group = "";
        }
        if (null == flags) {
            flags = "";
        }
        if (821 == mode) {
            if (isSafe) {
                if ("" == owner) {
                    owner = DEFAULT_SAFE_OWNER;
                }
                if ("" == group) {
                    group = DEFAULT_SAFE_GROUP;
                }
                if ("" == flags) {
                    flags = DEFAULT_SAFE_FLAGS;
                }
            } else {
                if ("" == owner) {
                    throw new IllegalArgumentException("Missing required \"owner\" argument");
                }
                if ("" == group) {
                    throw new IllegalArgumentException("Missing required \"group\" argument");
                }
                if ("" == flags) {
                    throw new IllegalArgumentException("Missing required \"flags\" argument");
                }
            }
        }
        String whenStr = "WHEN_REBOOT";
        if (711 == when) {
            whenStr = "WHEN_NOW";
        }
        String modeStr = "MODE_EXIST";
        if (821 == mode) {
            modeStr = "WHEN_ADD";
        }
        Trace.trace(TRACE_MASKF, "   FilePermissionsChanger" + TRACE_METHOD + " - file is [" + file + "]" + ", owner is [" + owner + "]" + ", group is [" + group + "]" + ", flags are [" + flags + "]" + ", when is " + whenStr + ", mode is " + modeStr);
        boolean success = false;
        Object object = mylock;
        synchronized (object) {
            success = 711 == when ? me.changePermissionsNow(file, owner, group, flags) : me.deferPermissionsChanges(file, owner, group, flags);
        }
        Trace.trace(TRACE_MASKT, "<- FilePermissionsChanger" + TRACE_METHOD);
        return success;
    }

    private boolean changePermissionsNow(String file, String owner, String group, String flags) {
        String TRACE_METHOD = ".changePermissionsNow()";
        Trace.trace(TRACE_MASKT, "-> FilePermissionsChanger" + TRACE_METHOD + " - [" + file + "], [" + owner + "], [" + group + "], [" + flags + "]");
        PatchFile theFile = new PatchFile(file);
        boolean result = theFile.setFilePermissions(owner, group, flags);
        Trace.trace(TRACE_MASKT, "<- FilePermissionsChanger" + TRACE_METHOD + " - " + result);
        return result;
    }

    private boolean deferPermissionsChanges(String file, String owner, String group, String flags) {
        String TRACE_METHOD = ".deferPermissionsChanges()";
        Trace.trace(TRACE_MASKT, "-> FilePermissionsChanger" + TRACE_METHOD + " - [" + file + "], [" + owner + "], [" + group + "], [" + flags + "]");
        boolean success = false;
        PermEntry newEntry = new PermEntry(file, owner, group, flags);
        if (this.filePerms.containsKey(file)) {
            this.filePerms.remove(file);
        }
        this.filePerms.put(file, newEntry);
        success = this.writeData();
        if (success) {
            ShutdownManager shutdownManager = ShutdownManager.getShutdownManager();
            try {
                shutdownManager.addScript(SHUTDOWN_SCRIPT_NAME, 1);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "   FilePermissionsChanger" + TRACE_METHOD + " - exception when writing deferred permissions data " + "file - data was [" + file + "], [" + owner + "], [" + group + "], [" + flags + "]");
                success = false;
            }
        }
        Trace.trace(TRACE_MASKT, "<- FilePermissionsChanger" + TRACE_METHOD + " - " + success);
        return success;
    }

    private boolean writeData() {
        String TRACE_METHOD = ".writeData()";
        Trace.trace(TRACE_MASKT, "-> FilePermissionsChanger" + TRACE_METHOD);
        boolean success = true;
        try {
            String filename = BaseFileControl.getFilePath(PERMISSIONS_DATA_FILE);
            filename = filename + PERMISSIONS_DATA_FILE;
            Collection perms = this.filePerms.values();
            File file = new File(filename);
            file.delete();
            if (!perms.isEmpty()) {
                PrintStream fp = new PrintStream(new FileOutputStream(file));
                String tmp = "";
                Iterator i = perms.iterator();
                while (i.hasNext()) {
                    PermEntry entry = (PermEntry)i.next();
                    fp.println("<file>" + entry.getFile());
                    tmp = entry.getOwner();
                    if (!tmp.equals("")) {
                        fp.println("<owner>" + tmp);
                    }
                    if (!(tmp = entry.getGroup()).equals("")) {
                        fp.println("<group>" + tmp);
                    }
                    if ((tmp = entry.getFlags()).equals("")) continue;
                    fp.println("<flags>" + tmp);
                }
                fp.close();
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception writing deferred permissions data file [iqzmPermissions.dat]");
            FrameworkLog log = new FrameworkLog(classLogInfo, -6800);
            log.log();
        }
        Trace.trace(TRACE_MASKT, "<- FilePermissionsChanger" + TRACE_METHOD + " - " + success);
        return success;
    }

    class PermEntry {
        private String file = "";
        private String owner = "";
        private String group = "";
        private String flags = "";

        PermEntry(String file, String owner, String group, String flags) {
            this.file = file;
            this.owner = owner;
            this.group = group;
            this.flags = flags;
        }

        String getFile() {
            return this.file;
        }

        String getOwner() {
            return this.owner;
        }

        String getGroup() {
            return this.group;
        }

        String getFlags() {
            return this.flags;
        }
    }
}

